try {
    // 基础路径
    var curDir = fl.scriptURI.replace('点击安装.jsfl', "");
    var configDir = fl.configURI;
    
    // 安装快捷键
    var sourceKeysFolder = curDir + "漫舟快捷键/";
    var targetKeysFolder = configDir + "Commands/漫舟快捷键/";
    
    // 确保目标目录存在
    FLfile.remove(targetKeysFolder);
    FLfile.createFolder(targetKeysFolder);
    
    // 复制所有JSFL文件
    var keyFiles = FLfile.listFolder(sourceKeysFolder + "*.jsfl", "files");
    if (keyFiles) {
        for (var i = 0; i < keyFiles.length; i++) {
            FLfile.copy(sourceKeysFolder + keyFiles[i], targetKeysFolder + keyFiles[i]);
        }
    }
    
    // WindowSWF目录
    var windowSWFDir = configDir + "WindowSWF/";
    
    // 删除旧版本插件（合并处理）
    var versionsToRemove = ["2.5", "3.0", "3.1", "3.2", "4.0", "4.1", "4.2", "4.3", "5.0", "5.1", "5.2", "5.3", "5.4", "6.0.0", "6.0.1","6.0.2","6.0.3"];
    for (var i = 0; i < versionsToRemove.length; i++) {
        FLfile.remove(windowSWFDir + "漫舟AN插件v" + versionsToRemove[i] + ".swf");
    }
    
    // 安装新版插件
    var sourcePluginFile = curDir + "漫舟AN插件v6.0.3.swf";
    var targetPluginFile = windowSWFDir + "漫舟AN插件v6.0.3.swf";
    FLfile.copy(sourcePluginFile, targetPluginFile);
    
    // 安装DLL文件
    var sourceDllFile = curDir + "Manzhou.dll";
    var targetDllFile = configDir + "External Libraries/Manzhou.dll";
    FLfile.remove(targetDllFile);
    FLfile.copy(sourceDllFile, targetDllFile);
    
    // 安装工具和图像
    var toolsDir = configDir + "Tools/";
    var toolFiles = [
        "漫舟FK骨骼连接.jsfl",
        "漫舟FK骨骼移动.jsfl",
        "漫舟FK连接.png",
        "漫舟FK连接_D.png",
        "漫舟FK移动.png",
        "漫舟FK移动_D.png"
    ];
    
    for (var i = 0; i < toolFiles.length; i++) {
        var sourceFile = curDir + toolFiles[i];
        var targetFile = toolsDir + toolFiles[i];
        FLfile.remove(targetFile);
        FLfile.copy(sourceFile, targetFile);
    }
    
    // 安装CHR文件夹和pd.exe
    var chrDir = "file:///C|/CHR/";
    FLfile.remove(chrDir);
    FLfile.createFolder(chrDir);
    FLfile.copy(curDir + "pd.exe", chrDir + "pd.exe");
    
    // 写入配置目录信息
    FLfile.write(chrDir + "AN.txt", fl.configDirectory);
    
    alert("漫舟AN插件v6.0.3.swf安装完成. An将自动关闭，请手动重启后：顶部-窗口-扩展-漫舟AN插件打开即可.");
    fl.quit();
    
} catch (e) {
    fl.trace(e);
    alert("漫舟提示：安装失败！");
} 